# Step 2: Implement Connection Pooling

# Global variable to hold the pool instance
db_pool = None

def initialize_connection_pool():
    """Initializes the connection pool using the defined configuration."""
    global db_pool
    try:
        # Create a Threaded Connection Pool (suitable for multi-threaded web servers)
        db_pool = pool.ThreadedConnectionPool(
            minconn=MIN_CONN,
            maxconn=MAX_CONN,
            **DB_CONFIG
        )
        print(f"\nConnection Pool initialized: Min={MIN_CONN}, Max={MAX_CONN}")
    except (Exception, psycopg2.Error) as error:
        print(f"Error while connecting to PostgreSQL: {error}")
        # Terminate application if pool setup fails
        exit(1)

# Initialize the pool once at application startup
initialize_connection_pool()
