# Step 3: Define a Pooled Query Execution Function

def execute_pooled_query(sql_query, params=None, fetch_results=True):
    """
    Acquires a connection from the pool, executes the query, 
    and immediately returns the connection.
    """
    conn = None
    try:
        # Get a connection from the pool (Fast operation)
        conn = db_pool.getconn()
        cursor = conn.cursor()

        # Execute the query
        cursor.execute(sql_query, params)
        
        # Commit changes for DML (INSERT/UPDATE/DELETE)
        if not sql_query.strip().upper().startswith("SELECT"):
            conn.commit()
            results = None
        elif fetch_results:
            results = cursor.fetchall()
        
        cursor.close()
        return results

    except (Exception, psycopg2.Error) as error:
        print(f"Error executing query: {error}")
        # In a production app, you would log this error
        if conn:
            conn.rollback() # Rollback changes on error
        return None

    finally:
        # IMPORTANT: Return the connection to the pool (Essential for efficiency)
        if conn:
            db_pool.putconn(conn)
            # print("Connection returned to pool.")
