# Step 4: Compare Inefficient vs. Efficient Queries

# --- Conceptual Data Setup (Assuming 'users' table exists) ---
# NOTE: This is conceptual; data setup would happen outside this demo.

# Inefficient Query: Fetches all columns, likely slow on large table
INEFFICIENT_SQL = "SELECT * FROM users WHERE creation_date > '2025-01-01' LIMIT 100;"

# Efficient Query: Fetches only necessary columns, uses an indexed primary key
EFFICIENT_SQL = "SELECT user_id, name, email FROM users WHERE user_id = %s;"
EFFICIENT_PARAMS = (42,) # Assuming a primary key search

# --- Execution Simulation ---
start_ineff = time.time()
execute_pooled_query(INEFFICIENT_SQL) # Query with high DB load
time_ineff = time.time() - start_ineff

start_eff = time.time()
execute_pooled_query(EFFICIENT_SQL, EFFICIENT_PARAMS) # Query with low DB load
time_eff = time.time() - start_eff

print("\n--- Query Efficiency Comparison (Time is conceptual difference) ---")
print(f"Inefficient Query Time: {time_ineff:.4f} seconds (High DB load)")
print(f"Efficient Query Time:   {time_eff:.4f} seconds (Low DB load)")

# The difference here highlights the benefit of SELECTing only required columns 
# and using indexed WHERE clauses.
