# Step 1: Setup and Clean Endpoint Design

from flask import Flask, jsonify, request, abort
import time
import json  # Used for conceptual file operations

# --- Configuration and Initialization ---
app = Flask(__name__)
API_VERSION = 'v1'
# Conceptual in-memory database
products_db = {
    101: {"name": "Laptop Pro", "price": 1500, "stock": 5},
    102: {"name": "Monitor Ultra", "price": 450, "stock": 12},
    103: {"name": "Keyboard Mechanical", "price": 120, "stock": 20},
}

# --- Resource-Based Endpoint Definitions ---
# GET /v1/products - Get all products (or a filtered list)
@app.route(f'/{API_VERSION}/products', methods=['GET'])
def get_products():
    # Implementation in Step 2/3
    pass

# GET /v1/products/{id} - Get a specific product
@app.route(f'/{API_VERSION}/products/<int:product_id>', methods=['GET'])
def get_product(product_id):
    # Implementation in Step 2/3
    pass

# POST /v1/products - Create a new product
@app.route(f'/{API_VERSION}/products', methods=['POST'])
def create_product():
    # Implementation in Step 2
    pass
