# Step 2: Handling JSON Data and Validation

@app.route(f'/{API_VERSION}/products', methods=['POST'])
def create_product():
    # 1. Validate Input (Request Body)
    if not request.json:
        abort(400, description="Request must be valid JSON.")

    required_fields = ['name', 'price', 'stock']
    if not all(field in request.json for field in required_fields):
        abort(400, description="Missing required fields: name, price, and stock.")

    # 2. Extract Data
    new_id = max(products_db.keys()) + 1
    new_product = {
        "name": request.json['name'],
        "price": request.json['price'],
        "stock": request.json['stock']
    }

    # 3. Process and Save (Conceptual)
    products_db[new_id] = new_product

    # 4. Respond with JSON
    return jsonify({"id": new_id, **new_product}), 201


@app.route(f'/{API_VERSION}/products/<int:product_id>', methods=['GET'])
def get_product(product_id):
    product = products_db.get(product_id)
    if product is None:
        abort(404, description=f"Product with ID {product_id} not found.")
    return jsonify(product)
