# Step 2: Handling User Input and Persistence

st.subheader("Persistent User Input")

# Use 'st.text_input' and assign a key. 
# Streamlit automatically stores its value in st.session_state[key].
# The 'value' field is set to read from the session state upon rerun.
user_input = st.text_input(
    "Enter your name (persists on rerun):",
    value=st.session_state.user_name, # Initialize with current state
    key='user_name' # Links widget value to st.session_state.user_name
)

st.write(f"Input Widget Value: **{user_input}**")
st.write(f"Session State Value: **{st.session_state.user_name}**")

# NOTE: The values are identical because the widget is linked by 'key'.
# If the user types a new name, st.session_state.user_name is updated 
# automatically, and the app reruns.
