# Step 3: Managing Dynamic Actions and Page Flow

st.subheader("Dynamic Action Management")

def update_state_and_process():
    """Callback function to run when the button is clicked."""
    st.session_state.button_clicked = True
    
    # Simulate a time-consuming data processing task
    st.session_state.processed_data = [
        f"Data item for {st.session_state.user_name} - {i}" for i in range(5)
    ]
    st.session_state.page_count += 1
    st.info("Data processed and state updated! App will now rerun.")
    
# Button to trigger the update_state_and_process function
st.button(
    "Process Data & Go to Next Step",
    on_click=update_state_and_process,
    disabled=st.session_state.button_clicked # Disable after first click
)

# --- Display Results Based on State ---
if st.session_state.button_clicked:
    st.success(f"Processing Complete (Step {st.session_state.page_count - 1} data):")
    for item in st.session_state.processed_data:
        st.code(item)
    
    # Example of another button to reset the state
    if st.button("Reset Application"):
        # Reset relevant state variables to initial values
        st.session_state.page_count = 1
        st.session_state.processed_data = []
        st.session_state.button_clicked = False
        st.rerun() # Force a full rerun to reflect the reset state
