---
layout: post
title: Hydejack's New Design
description: >
  This post introduces Hydejack's now background image, color palette and logo.
image: /assets/img/blog/caleb-george.jpg
hide_image: true
---

While v7 brings an [insane amount of new stuff]({{ site.baseurl }}/CHANGELOG/#v700), the most notable change is the new background image.
It is no longer *anti-selling* the theme.
The old image was a blurred version of Napoleon Bonaparte, which was just... weird. I could tell the story of how this came to be,
but I'd rather show you the new and improved background image.

## New background image
Yes, it's an aerial shot of a beach ([so hot right now](https://duckduckgo.com/?q=ios+11+background&t=ffab&iax=images&ia=images)).

![Hydejack's background image]({{ site.baseurl }}/assets/img/blog/caleb-george.jpg){:.lead width="1920" height="1200" loading="lazy"}
Hydejack's new background image.
{:.figure}

Q: What has this picture to do with Hydejack?
Nothing really, I just like how it looks.
However: Boat → Pirates → Hijacking → Hydejack (illuminati confirmed)

Even though it is a free image from [Unsplash](https://unsplash.com/) (...), it's unique in the sense that
I've modified it so it looks better inside the sidebar.
Specifically, I've straightened out the beach and rotated the boat so that it sits at a nice 90 degree angle.

For comparison, here is the non-euclidean mess the [original photo](https://unsplash.com/photos/AtvuPUenaeI) was. Pretty OCD, I know.

![Original photo]({{ site.baseurl }}/assets/img/blog/caleb-george-old.jpg){:.lead :width="1920" height="1200" loading="lazy"}
The original photo before it was "straightened out" by applying Photoshop magic.
{:.figure}

## New color palette
I've extracted the major colors from the background image, which now form Hydejack's color palette:

![Hydejacks's color palette]({{ site.baseurl }}/assets/img/blog/COLOURlovers.com-Hydejack.png){:.lead style="border: 1px solid var(--border-color)" width="1024" height="200" loading="lazy"}

## New logo
Hydejack also has a new logo, which is based on the new color palette.
It also features the best font on Google Fonts, and probably the world: [Roboto Slab](https://fonts.google.com/specimen/Roboto+Slab)
(which is to say, I like it a lot).

![Hydejack's logo]({{ site.baseurl }}/assets/icons/icon-384x384.png){:width="192" height="192" loading="lazy" sizes="192px" srcset="{{ site.baseurl }}/assets/icons/icon-384x384.png 384w, {{ site.baseurl }}/assets/icons/icon-192x192.png 192w"}


[^1]: I should mention that these are only default values. Hydejack let's you choose your own. For inspiration, I've recently added [a gallery]({{ site.baseurl }}/projects/) to the site that shows a few variations of the theme.
