---
layout: post
title: Introducing Hydejack 8
image: 
  path: /assets/img/blog/hydejack-8.jpg
  srcset: 
    1920w: /assets/img/blog/hydejack-8.jpg
    960w:  /assets/img/blog/hydejack-8@0,5x.jpg
    480w:  /assets/img/blog/hydejack-8@0,25x.jpg
description: >
  Hydejack 8 is the best version of Hydejack yet.
  It introduces Cover Pages, Offline Support, and soon... Dark Mode.
related_posts:
  - /blog/hydejack/2018-09-01-introducing-dark-mode/
  - /blog/hydejack/2019-07-31-service-release-8.5.0/
---

After a long wait, Hydejack 8 finally sees the day of its release. It makes Hydejack look more elegant (no more super bold headings) and introduces features that make your site more impressive to first time visitors, while loading faster for repeat visitors.

* toc
{:toc .large-only}

### Cover Pages

The new design doubles down on Hydejack as your personal site. The new Cover Pages let visitors know what you're about at a glance, showing your logo or profile picture, tagline or description, and selection of social media icons.

![Cover page slide animation](/assets/img/blog/cover-page.jpg){:.lead width="1440" height="836" loading="lazy"}
Sliding over a cover page will reveal the content below.
{:.figure}

### Lazy-Loading Images

Using lots of images can severely impact the performance of a site. It can also cause layout quirks when images pop into existence.
In Hydejack 8 you have the option to provide `width` and `height` information for your images and let Hydejack lazy-load them as readers scroll the page.

![Lazy loading demo](/assets/img/blog/lazy-images.jpg){:.lead width="1440" height="836" loading="lazy"}
Images are loaded as they are scrolled into view.
{:.figure}

### Better Blog Layout

The `blog` layout finally catches up to modern design standards and renders a posts's `image` as part of the preview, giving it a tastier look that makes visitors more likely to engage.

![Scrolling through the blog layout](/assets/img/blog/blog-layout.jpg){:.lead width="1440" height="836" loading="lazy"}
Hydejack's improved blog layout renders each post's image.
{:.figure}

### Dark Mode 🌗 (coming soon)

In 8.1, buyers of the PRO version will have access to Dark Mode. At your choosing, it will be enabled by default, enabled based on visitors' local time, or flipped on by a switch.

![Dark Mode Teaser](/assets/img/blog/dark-mode.jpg){:.lead width="1440" height="836" loading="lazy"}
Hydejack switches between light and dark mode fluidly.
{:.figure}

### Offline Support ⚡️

Version 8 introduces experimental offline support. This allows visitors to navigate your site while offline and continue reading articles when connectivity is lost. It also improves loading times for repeat visitors dramatically.
