# Contributing to Tourism Website

    We love your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

        -Reporting a bug
        -Discussing the current state of the code
        -Submitting a fix
        -Proposing new features

# Steps to contribute

    Comment on the issue you want to work on. Make sure it's not assigned to someone else.

    If you think an some features is missing or some bug feel free to create an issue.

# Making a PR

    Make sure you have been assigned the issue to which you are making a PR.
    If you make PR before being assigned, It will be closed without merging.

# Steps To Work

    Fork the repo and clone it on your machine.
    
    Add a upstream link to main branch in your cloned repo
    
    git remote add upstream https://github.com/PritamSarbajna/tourism-website.git
    
    Keep your cloned repo upto date by pulling from upstream (this will also avoid any merge conflicts while committing new changes)
    
    git pull upstream main
    
    Create your feature branch
    
    git checkout -b <feature-name>
    
    Commit all the changes
    
    git commit -m "Meaningful commit message"
    
    Push the changes for review
    
    git push origin HEAD
    
    Create a PR from our repo on Github.
    

# Additional Notes

    Code should be properly commented to ensure it's readability.
    Make sure your code properly formatted.
    Issue that pull request!
    Issue suggestions/Bug reporting
    When you are creating an issue, make sure it's not already present. Furthermore, provide a proper description of the changes. If you are suggesting any code improvements, provide through details about the improvements.

    Great Issue suggestions tend to have:

    A quick summary of the changes.
    In case of any bug provide steps to reproduce
    Be specific!
    Give sample code if you can.
    Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)
    
# Contributing

We love pull requests from everyone. By participating in this project, you
agree to abide by the [Code Of Conduct](https://github.com/PritamSarbajna/tourism-website/blob/main/CODE_OF_CONDUCT.md).

# License

    By contributing, you agree that your contributions will be licensed under its MIT License.
